﻿using System;
using System.Windows.Forms;
using Psion.RFID.HF;

namespace HF_Demo
{
    public partial class MainForm : Form
    {
        private readonly Reader _reader; //RFID Reader instance

        public MainForm(Reader reader)
        {
            InitializeComponent();

            if (!Device.IsWM) mainMenu1.Dispose();

            _reader = reader;
        }

        private void IconButtonReadIDClick(object sender, EventArgs e)
        {
            var f = new ReadIDForm(_reader);
            f.ShowDialog();
            f.Dispose();
        }

        private void IconButtonScriptClick(object sender, EventArgs e)
        {
            var f = new ScriptForm(_reader);
            f.ShowDialog();
            f.Dispose();
        }

        private void IconButtonEEPROMClick(object sender, EventArgs e)
        {
            var f = new EepromForm(_reader);
            f.ShowDialog();
            f.Dispose();
        }

        private void IconButtonPluginsClick(object sender, EventArgs e)
        {
            var f = new PlugInsForm(_reader);
            f.ShowDialog();
            f.Dispose();
        }

        private void IconButtonHyperTerminalClick(object sender, EventArgs e)
        {
            var f = new HyperTerminalForm(_reader);
            f.ShowDialog();
            f.Dispose();
        }

        private void IconButtonAboutClick(object sender, EventArgs e)
        {
            var f = new AboutForm(_reader);
            f.ShowDialog();
            f.Dispose();
        }

        private void MenuItem1Click(object sender, EventArgs e)
        {
            Close();
        }

    }
}